#ifndef FILEUTIL__H
#define FILEUTIL__H
/////////////////////////////////////////////////////////////////////////////
#ifdef COMMON_EXPORTS
	#define COMMON_API __declspec(dllexport)
#else
	#define COMMON_API __declspec(dllimport)
#endif
/////////////////////////////////////////////////////////////////////////////
#include "VPincs.h"
#include "FileDB.h"
#include "FileText.h"
/////////////////////////////////////////////////////////////////////////////
#define VPAppMaxFileNameLength				31
#define	kDefaultConfigFile					"DefaultConfigFile"
#define	kDefaultFullConfigFile				"DefaultConfigFile.vpc"
#define kDefaultConfigFileExt				".vpc"
/////////////////////////////////////////////////////////////////////////////
class COMMON_API CFileUtil
{
private:
	static CFileUtil* fileUtil;
	CFileText*	sMainLogFile;
	CFileDB*	sMainCfgFile;
	char		mPath[MAX_PATH];

public:
	CFileUtil(char* iPath);
	virtual ~CFileUtil(){};

	static Bool			Build(char* iAppPath);

	Bool				InitInstance(CString iFileName);
	void				ExitInstance();
	void				SetFileDB(CFileDB* iFileDB);

	UInt8				DeleteConfigFile();
	CFileDB*			GetMainConfigFile(){return sMainCfgFile;}
	CFileText*			GetMainLogFile(){return sMainLogFile;}
	CFileText*			MakeTextFile(char* iInNameP, char* inFolderP=NULL);	
	CFileDB*			MakeDBFile(char* iInNameP, char* inFolderP=NULL, char* iExt=NULL);
	UInt8				DeleteDBFile(char* iInNameP, char* inFolderP=NULL, char* iExt=NULL);

	static CFileUtil*	GetFileUtil(Bool build = true);
	char*				GetFullFileName(const char* iInNameP, const char iExtP[4], const char* iInFolderP=NULL);

};
/////////////////////////////////////////////////////////////////////////////
//Use these two macros to create text files and db files
#define MAKE_TEXT_FILE(name)	CFileUtil::GetFileUtil()->MakeTextFile(name)
#define MAKE_DB_FILE(name)		CFileUtil::GetFileUtil()->MakeDBFile(name)
/////////////////////////////////////////////////////////////////////////////
#define MAKE_TEXT_FILE_IN_FOLDER(name, folder)	CFileUtil::GetFileUtil()->MakeTextFile(name, folder)
#define MAKE_DB_FILE_IN_FOLDER(name, folder)	CFileUtil::GetFileUtil()->MakeDBFile(name, folder)
#define MAKE_EXT_DB_FILE_IN_FOLDER(name, folder,ext)	CFileUtil::GetFileUtil()->MakeDBFile(name, folder,ext)
//Use these two macros to obtain pointers to the configuration and loq files
#define	MAIN_CFG_FILE		CFileUtil::GetFileUtil()->GetMainConfigFile()
#define	MAIN_ATLOG_FILE		CFileUtil::GetFileUtil()->GetMainLogFile()
/////////////////////////////////////////////////////////////////////////////
#endif
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

